! Davicom Bootloader fixup, switches off the DAVICOM fast ethernet chip
! before transfering control to the RPL'd image, so that the chip
! doesn't scribble all over it while it relocates
!
! This image needs 2k of memory, and can be loaded anywhere, after
! it does its stuff it does jmp 0x9020:0x0
!
! 
!
! $Id: dmfix.S,v 1.4 1999/09/14 17:18:27 root Exp $ll rights reserved
!
!  Copyright (c) 1999, James McKenzie.
!                       All rights reserved
!  Copyright (c) 1999, Christopher Lightfoot.
!                       All rights reserved
! 
!  By using this file, you agree to the terms and conditions set
!  forth in the LICENCE file which can be found at the top level of
!  the rpld distribution.
! 
!  DAVICOM is a trademark of DAVICOM semiconductor inc.
! 
!
!
! $Log: dmfix.S,v $
! Revision 1.4  1999/09/14 17:18:27  root
! #
!
! Revision 1.3  1999/09/13 12:32:26  root
! #
!
! Revision 1.2  1999/09/12 05:07:29  root
! *** empty log message ***
!
!

! Offsets into the PCI config space
#define PCI_VENDOR_ID 			0x00
#define PCI_DEVICE_ID 			0x02
#define PCI_HEADER_TYPE 		0x0e
#define PCI_BASE_ADDRESS_0 		0x10

!PCI constants
#define PCI_BASE_ADDRESS_IO_MASK 	0xfffc
#define PCI_VENDOR_ID_DAVICOM 		0x1282
#define PCI_DEVICE_ID_DAVICOM_9102 	0x9102


.globl begtext, begdata, begbss, endtext, enddata, endbss
.text
begtext:
.data
begdata:
.bss
begbss:
.text

entry start
start:
	mov ax,cs
	mov es,ax
	mov ds,ax
	mov ss,ax

! Put the stack at us+2k
	mov di,#0x800-12
	mov sp,di

! Say hello
	lea si,hello
	call prtstr
	call print_nl

	lea si,top
	call prtstr
	call print_nl

! Scan the pci bus
	mov byte (devfn),#0

dev_loop:
		mov bh, byte (devfn)  		!Device number
		mov bl,#PCI_VENDOR_ID 		!Offset into config space
		mov cl, byte (bus)		!Bus number
		call pci_read_config_word

		cmp ax,#0xffff
		beq dull
		cmp ax,#0x0000
		beq dull

			mov (vid),ax

			xor dh,dh	
			mov dl,byte (bus)
	
			call print_2hex
 			call print_sp	
	
			mov dl, byte (devfn)
			sar dl,#3
			and dx,#0x1f
	
			call print_2hex
			call print_sp
	
			mov dl, byte (devfn)
			and dl,#7
	
			call print_2hex
			call print_sp
		
			mov dx,(vid)
			call print_hex
			call print_sp
	
			mov bh, byte (devfn)  	!Device number
			mov bl,#PCI_DEVICE_ID 	!Offset into config space
			mov cl,byte (bus)	!Bus number
			call pci_read_config_word
	
			mov (did),ax
		
			mov dx,ax
			call print_hex
			call print_sp
	
			mov bh, byte (devfn)  !Device number
			mov bl,#PCI_BASE_ADDRESS_0 !Offset into config space
			mov cl, byte (bus)	!Bus number
			call pci_read_config_word
	
			and ax,#PCI_BASE_ADDRESS_IO_MASK
			mov (dad),ax
	
			mov dx,ax
			call print_hex
			call print_sp
	
	
			cmp (vid),#PCI_VENDOR_ID_DAVICOM
			bne skipfix
			cmp (did),#PCI_DEVICE_ID_DAVICOM_9102
			bne skipfix
	
				mov dx,(dad) !Hit the Reset bit
				in eax,dx
				or eax,#1
				out dx,eax
		
				lea si,fixed
				call prtstr
	
skipfix:
	
	
			mov bh, byte (devfn)  	!Device number
			mov bl,#PCI_HEADER_TYPE !Offset into config space
			mov cl,byte (bus)	!Bus number
			call pci_read_config_byte
	
			and al,#0x80
			cmp al,#0x80
			beq multi
				inc byte (devfn)
				inc byte (devfn)
				inc byte (devfn)
				inc byte (devfn)
				inc byte (devfn)
				inc byte (devfn)
				inc byte (devfn)
multi:

			call print_nl

dull:


		inc byte (devfn)
		mov dl, byte (devfn)
		cmp dl,#0
		beq dev_loop_skip
			br dev_loop
dev_loop_skip:

	lea si,done
	call prtstr
	call print_nl

! Hand over control to the linux 2ndary boot loader
	jmp 0x9020:0x0


! bh contains device_fn
! bl conatins offset
! cl contains the bus number


pci_read_config_word: 
	push bx
	and bl,#0xfc
	mov ch,#0x80

	mov (controldword),bx
	mov (controldword+2),cx

	mov eax,(controldword)
	mov dx,#0xcf8
	out dx,eax

	pop dx
	and dx,#0x2
	add dx,#0xcfc

	in ax,dx
	ret

pci_read_config_byte: 
	push bx
	and bl,#0xfc
	mov ch,#0x80

	mov (controldword),bx
	mov (controldword+2),cx

	mov eax,(controldword)
	mov dx,#0xcf8
	out dx,eax

	pop dx
	and dx,#0x3
	add dx,#0xcfc

	in al,dx
	ret


prtstr: 
		lodsb
        	and     al,al
        	jz      fin
        	call    prtchr
        jmp     prtstr
fin:    ret

prtchr: push    ax
        push    cx
        xor     bh,bh
        mov     cx,#0x01
        mov     ah,#0x0e
        int     0x10
        pop     cx
        pop     ax
        ret

print_hex:
        mov     cx, #4          ! 4 hex digits
print_digit:
        rol     dx, #4          ! rotate so that lowest 4 bits are used
        mov     ax, #0xe0f      ! ah = request, al = mask for nybble
        and     al, dl
        add     al, #0x90       ! convert al to ascii hex (four instructions)
        daa
        adc     al, #0x40
        daa
        int     0x10
        loop    print_digit
        ret

print_2hex:
        mov     cx, #2          ! 2 hex digits
print_2digit:
        rol     dx, #4          ! rotate so that lowest 4 bits are used
        mov     ax, #0xe0f      ! ah = request, al = mask for nybble
        and     al, dl
        add     al, #0x90       ! convert al to ascii hex (four instructions)
        daa
        adc     al, #0x40
        daa
        int     0x10
        loop    print_2digit
        ret

print_sp:
        mov     ax, #0xe20      ! SP
        int     0x10
        ret

print_nl:
        mov     ax, #0xe0d      ! CR
        int     0x10
        mov     al, #0xa        ! LF
        int     0x10
        ret

davicom_base:
	.word   0x0
bus:
	.byte 	0x0
devfn:
	.byte	0x0

controldword:
	.word 0
	.word 0
vid:
	.word 0
did:
	.word 0
dad:	
	.word 0

hello:    .ascii  "DAVICOM killer (c) 1999 James McKenzie <james@fishsoup.dhs.org>"
                db      0x00

top: 	.ascii "Bs Sl Fn VID  DID  Window 0 base"
	db 0x00
fixed: 	.ascii "- FIXED"
	db 0x00

done:   .ascii "Transfering control to linux secondary boot loader"
	db 0x00

.text
endtext:
.data
enddata:
.bss
endbss:

