#include <stdio.h>
#include <strings.h>

static char *rcsid = "$Id: ana.c,v 1.2 1999/09/13 12:37:06 root Exp $";

/* 
 * $Log: ana.c,v $
 * Revision 1.2  1999/09/13 12:37:06  root
 * #
 *
 * Revision 1.1  1999/09/13 12:36:18  root
 * #
 *
 * Revision 1.4  1999/09/02 09:59:02  root
 * #
 *
 * Revision 1.3  1999/09/02 09:58:02  root
 * #
 *
 */


unsigned char pbuf[4096];
int plen;
char buf[1024];

get_packet ()
{
  char *ptr, *pptr;

  plen = 0;

  while (!feof (stdin) && *buf == '\t')
    {
      fgets (buf, sizeof (buf) - 1, stdin);
    }
  while (!feof (stdin) && *buf != '\t')
    {
      buf[strlen (buf) - 1] = 0;
      puts (buf);
      fgets (buf, sizeof (buf) - 1, stdin);
    }
  if (feof (stdin))
    return;

  sscanf (buf, "%x", &plen);

  pptr = pbuf;


  while (!feof (stdin) && *buf == '\t')
    {
      ptr = buf;

      while (!isxdigit (*ptr))
        ptr++;
      while (*ptr)
        {
          char hex[3];

          bcopy (ptr, hex, 3);
          hex[2] = 0;
          ptr++;
          ptr++;

          sscanf (hex, "%x", pptr);
          pptr++;

          while (*ptr && !isxdigit (*ptr))
            ptr++;
        }


      fgets (buf, sizeof (buf) - 1, stdin);
    }

}

int
pull_short (unsigned char *c)
{
  int ret;
  ret = *c;
  c++;
  ret <<= 8;
  ret += *c;
  return (ret);
}
unsigned int
pull_long (unsigned char *c)
{
  unsigned int ret;

  ret = *c;
  c++;
  ret <<= 8;
  ret += *c;
  c++;
  ret <<= 8;
  ret += *c;
  c++;
  ret <<= 8;
  ret += *c;

  return (ret);
}

dump_hex (unsigned char *pp, int pl)
{
  while (pl--)
    {
      printf (" %02x", *(pp++));
    }
}

dump_hexa (unsigned char *pp, int pl)
{
  while (pl--)
    {
      int j = *pp;
      if ((j < ' ') || (j > 126))
        j = '.';
      printf (" %02x%c", *pp, j);
      pp++;
    }
}

ana_token (int s, unsigned char *pp, int pl)
{
  int i;
  printf ("    Token 0x%04x:", s);
  switch (s)
    {
    case 0x4003:
      printf (" The mighty zero: %d\n", pull_long (pp));
      return;
    case 0x4006:
      printf (" My MAC addr: %02x:%02x:%02x:%02x:%02x:%02x\n",
              pp[0], pp[1], pp[2], pp[3], pp[4], pp[5]);
      return;
    case 0x4007:
      printf (" My SAP addr: %02x\n", pp[0]);
      return;
    case 0x4009:
      printf (" Frame len: %d\n", pull_short (pp));
      return;
    case 0x400b:
      printf (" The small zero: %d\n", *pp);
      return;
    case 0x400c:
      printf (" Your MAC addr: %02x:%02x:%02x:%02x:%02x:%02x\n",
              pp[0], pp[1], pp[2], pp[3], pp[4], pp[5]);
      return;
    case 0x4011:
      printf (" Block number: %d\n", pull_long (pp));
      return;
    case 0x4018:
      printf (" data block: (ommitted %d bytes of guff)\n", pl);
      return;
    case 0xc005:
      printf (" IDENT: ");
      dump_hexa (pp, pl);
      printf ("\n");
      return;
    case 0xc014:
      printf (" addr block: Load @ 0x%08x, Run @ 0x%08x, Flags: 0x%02x",
              pull_long (pp), pull_long (pp + 4), pp[8]);
      switch (pp[8])
        {
        case 0x20:
          printf (" (More to come)");
          break;
        case 0xc0:
          printf (" (All done, execute)");
          break;
        default:
          printf (" ?");
        }

      printf ("\n");
      return;
    default:
      printf (" ?: ");
      dump_hex (pp, pl);
      printf ("\n");

    }

}

int
ana_frag (unsigned char *pp, int pl)
{
  int s;

  while (pl > 0)
    {

      s = pull_short (pp);

      if (s & 0xc000)
        {
          ana_token (s, pp + 2, pl - 2);
          return;
        }
      else
        {
          ana_frag (pp + 2, s - 2);
          pp += s;
          pl -= s;
        }

    }

}




main ()
{
  int i, s;
  char *pptr;
  *buf = '\t';

  while (!feof (stdin))
    {
      get_packet ();

      pptr = pbuf;
      pptr += 2;                /*Length */
      plen -= 2;

      printf ("  Pack Type:");
      switch (pull_short (pptr))
        {
        case 0x1:
          printf (" FIND:");
          break;
        case 0x2:
          printf (" FOUND:");
          break;
        case 0x10:
          printf (" SEND.FILE.REQUEST:");
          break;
        case 0x20:
          printf (" FILE.DATA.RESPONSE:");
          break;
        default:
          printf (" 0x%04x ?:", pull_short (pptr));
        }
      printf (" Length=%d\n", plen);
      pptr += 2;
      plen -= 2;

      s = ana_frag (pptr, plen);


      printf ("\n\n");
    }

  exit (0);

}
